/*
 * Decompiled with CFR 0.152.
 */
package io.github.hw9636.autosmithingtable.common;

import io.github.hw9636.autosmithingtable.common.AutoSmithingContainer;
import io.github.hw9636.autosmithingtable.common.AutoSmithingTableBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoSmithingTableBlock
extends Block
implements EntityBlock {
    private static final Component CONTAINER_TITLE = new TranslatableComponent("container.autosmithingtable.title");
    private static final Component tooltip = new TranslatableComponent("tooltip.autosmithingtable.sides");

    public AutoSmithingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof AutoSmithingTableBlockEntity) {
            AutoSmithingTableBlockEntity be = (AutoSmithingTableBlockEntity)blockEntity;
            ItemStack itemStack = player.m_21120_(pHand);
            if (itemStack.m_41619_() && player.m_6047_()) {
                Direction direction;
                int sidesConfig = be.data.m_6413_(3);
                int value = AutoSmithingTableBlockEntity.getSide(sidesConfig, direction = pHit.m_82434_());
                int newValue = value < 3 ? value + 1 : 0;
                be.data.m_8050_(3, AutoSmithingTableBlockEntity.setSide(direction, newValue, sidesConfig));
                player.m_6352_((Component)new TranslatableComponent("message.autosmithingtable.change_side_to_" + newValue), player.m_142081_());
                return InteractionResult.SUCCESS;
            }
            SimpleMenuProvider menu = new SimpleMenuProvider(AutoSmithingContainer.getServerContainer(be, pos), CONTAINER_TITLE);
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)menu, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (state.m_155947_() && state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof AutoSmithingTableBlockEntity) {
            AutoSmithingTableBlockEntity be = (AutoSmithingTableBlockEntity)blockEntity;
            be.dropItems(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        super.m_6810_(state, level, pos, newState, pIsMoving);
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add(tooltip);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : (level, pos, state0, blockentity) -> ((AutoSmithingTableBlockEntity)blockentity).serverTick();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new AutoSmithingTableBlockEntity(pos, state);
    }
}

